/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ComprobanteCompra;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ValoresComprobanteReembolso;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Reembolso
extends Comprobante
implements Exportable {
    private static final long serialVersionUID = -7832726771801636838L;
    public static final String C_TIPO_COMPROBANTE_REEMBOLSO = "tipoComprobanteReembolso";
    private Sujeto proveedor = new Sujeto("tpIdProvReemb", "idProvReemb", "1");
    private String tipoComprobanteReembolso;
    private String descripcionTipoComprobanteReembolso;
    private ValoresComprobanteReembolso valoresComprobanteReembolso;
    private ComprobanteCompra compraSeleccionada;

    public Reembolso() {
        this.proveedor.setPropietario((ObjetoModelo)this);
        this.valoresComprobanteReembolso = new ValoresComprobanteReembolso();
        this.valoresComprobanteReembolso.setPropietario((ObjetoModelo)this);
    }

    @Override
    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        resultado = this.getProveedor().validar();
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        if (StringUtil.isNullOrEmpty((String)this.getTipoComprobanteReembolso())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de Comprobante");
        }
        resultado = super.validarObjeto();
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        resultado = this.getValoresComprobanteReembolso().validar();
        if (!resultado.esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    @Override
    public Reembolso crearCopiaEdicion() {
        Reembolso copia = new Reembolso();
        copia.setEstablecimiento(super.getEstablecimiento());
        copia.setPuntoEmision(super.getPuntoEmision());
        copia.setSecuencial(super.getSecuencial());
        copia.setNumAutorizacion(super.getNumAutorizacion());
        copia.setFechaEmision(super.getFechaEmision());
        copia.setObligatorio(super.isObligatorio());
        copia.setTipoComprobanteReembolso(this.tipoComprobanteReembolso);
        copia.setDescripcionTipoComprobanteReembolso(this.descripcionTipoComprobanteReembolso);
        copia.setCompraSeleccionada(this.compraSeleccionada);
        copia.setPropietario(this.propietario);
        copia.proveedor = this.proveedor.crearCopiaEdicion();
        copia.getProveedor().setPropietario((ObjetoModelo)copia);
        copia.valoresComprobanteReembolso = this.valoresComprobanteReembolso.crearCopiaEdicion();
        copia.getValoresComprobanteReembolso().setPropietario((ObjetoModelo)copia);
        return copia;
    }

    @Override
    public void actualizarInformacion(Comprobante copiaEdicion) {
        Reembolso reembolso = (Reembolso)copiaEdicion;
        this.setProveedor(reembolso.getProveedor());
        this.setValoresComprobanteReembolso(reembolso.getValoresComprobanteReembolso());
        this.setTipoComprobanteReembolso(reembolso.getTipoComprobanteReembolso());
        this.setDescripcionTipoComprobanteReembolso(reembolso.getDescripcionTipoComprobanteReembolso());
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("tipoComprobanteReemb");
        Element eValor = (Element)valorList.item(0);
        this.tipoComprobanteReembolso = eValor.getTextContent().trim();
        this.descripcionTipoComprobanteReembolso = String.valueOf(this.getTipoComprobanteReembolso()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionComprobante(this.getTipoComprobanteReembolso());
        valorList = elemento.getElementsByTagName("establecimientoReemb");
        eValor = (Element)valorList.item(0);
        this.setEstablecimiento(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("puntoEmisionReemb");
        eValor = (Element)valorList.item(0);
        this.setPuntoEmision(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("secuencialReemb");
        eValor = (Element)valorList.item(0);
        this.setSecuencial(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("autorizacionReemb");
        eValor = (Element)valorList.item(0);
        this.setNumAutorizacion(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("fechaEmisionReemb");
        eValor = (Element)valorList.item(0);
        this.setFechaEmision(Util.importarFecha(eValor));
        this.getProveedor().importar(elemento, null);
        this.getValoresComprobanteReembolso().importar(elemento, null);
        return this;
    }

    @Override
    protected ResultadoValidacion validarFechaEmision(ResultadoValidacion resultado) {
        if (!Util.isFechaMenorIgual(this.getFechaEmision(), this.getCompraSeleccionada().getFechaEmision())) {
            return resultado.fallarValidacion("La Fecha de Emisi\u00f3n Reembolso debe ser menor o igual a la Fecha de Emision del Comprobante de\tVenta (" + Constantes.FORMATO_FECHA.format(this.getCompraSeleccionada().getFechaEmision()) + ")");
        }
        if (!Util.isFechaMenorUnAnio(this.getFechaEmision(), this.getCompraSeleccionada().getFechaEmision())) {
            return resultado.fallarValidacion("La Fecha de Emisi\u00f3n Reembolso no debe ser menor con mas de un a\u00f1o a la Fecha de Emisi\u00f3n del Comprobante de\tVenta (" + Constantes.FORMATO_FECHA.format(this.getCompraSeleccionada().getFechaEmision()) + ")");
        }
        return resultado;
    }

    public Sujeto getProveedor() {
        return this.proveedor;
    }

    public String getTipoComprobanteReembolso() {
        return this.tipoComprobanteReembolso;
    }

    public String getDescripcionTipoComprobanteReembolso() {
        return this.descripcionTipoComprobanteReembolso;
    }

    public ValoresComprobanteReembolso getValoresComprobanteReembolso() {
        return this.valoresComprobanteReembolso;
    }

    public ComprobanteCompra getCompraSeleccionada() {
        return this.compraSeleccionada;
    }

    public void setTipoComprobanteReembolso(String tipoComprobanteReembolso) {
        String oldValue = this.tipoComprobanteReembolso;
        this.tipoComprobanteReembolso = tipoComprobanteReembolso;
        this.firePropertyChange(C_TIPO_COMPROBANTE_REEMBOLSO, oldValue, this.tipoComprobanteReembolso);
    }

    public void setDescripcionTipoComprobanteReembolso(String descripcionTipoComprobanteReembolso) {
        this.descripcionTipoComprobanteReembolso = descripcionTipoComprobanteReembolso;
    }

    public void setProveedor(Sujeto proveedor) {
        this.proveedor = proveedor;
    }

    public void setValoresComprobanteReembolso(ValoresComprobanteReembolso valoresComprobanteReembolso) {
        this.valoresComprobanteReembolso = valoresComprobanteReembolso;
    }

    public void setCompraSeleccionada(ComprobanteCompra compraSeleccionada) {
        this.compraSeleccionada = compraSeleccionada;
    }

    public String getSerial() {
        return String.valueOf(this.getEstablecimiento()) + "-" + this.getPuntoEmision() + "-" + this.getSecuencial();
    }

    public Element exportar(Document documento, Element elemento) {
        Element reeembolso = documento.createElement("reembolso");
        Element detalleReembolso = documento.createElement("tipoComprobanteReemb");
        detalleReembolso.setTextContent(this.getTipoComprobanteReembolso());
        reeembolso.appendChild(detalleReembolso);
        String tpIdProvReemb = UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacion("1", this.getProveedor().getTipoIdentificacion());
        detalleReembolso = documento.createElement("tpIdProvReemb");
        detalleReembolso.setTextContent(tpIdProvReemb);
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("idProvReemb");
        detalleReembolso.setTextContent(this.getProveedor().getIdentificacion());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("establecimientoReemb");
        detalleReembolso.setTextContent(this.getEstablecimiento());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("puntoEmisionReemb");
        detalleReembolso.setTextContent(this.getPuntoEmision());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("secuencialReemb");
        detalleReembolso.setTextContent(this.getSecuencial());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("fechaEmisionReemb");
        detalleReembolso.setTextContent(Util.dateToStringWithFormat(this.getFechaEmision(), Constantes.FORMATO_FECHA.toPattern()));
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("autorizacionReemb");
        detalleReembolso.setTextContent(this.getNumAutorizacion());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("baseImponibleReemb");
        detalleReembolso.setTextContent(this.getValoresComprobanteReembolso().getBaseIvaCero());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("baseImpGravReemb");
        detalleReembolso.setTextContent(this.getValoresComprobanteReembolso().getBaseIvaNoCeroReembolso());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("baseNoGraIvaReemb");
        detalleReembolso.setTextContent(this.getValoresComprobanteReembolso().getBaseNoIvaReemb());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("baseImpExeReemb");
        detalleReembolso.setTextContent(this.getValoresComprobanteReembolso().getBaseImponibleExcentaIva());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("montoIceRemb");
        detalleReembolso.setTextContent(this.getValoresComprobanteReembolso().getMontoIce());
        reeembolso.appendChild(detalleReembolso);
        detalleReembolso = documento.createElement("montoIvaRemb");
        detalleReembolso.setTextContent(this.getValoresComprobanteReembolso().getMontoIvaReembolso());
        reeembolso.appendChild(detalleReembolso);
        return reeembolso;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.proveedor == null ? 0 : this.proveedor.hashCode());
        result = 31 * result + (this.tipoComprobanteReembolso == null ? 0 : this.tipoComprobanteReembolso.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Reembolso)) {
            return false;
        }
        Reembolso other = (Reembolso)((Object)obj);
        if (this.proveedor == null ? other.proveedor != null : !this.proveedor.equals((Object)other.proveedor)) {
            return false;
        }
        return !(this.tipoComprobanteReembolso == null ? other.tipoComprobanteReembolso != null : !this.tipoComprobanteReembolso.equals(other.tipoComprobanteReembolso));
    }
}

